//
// Procedimientos de usuario
//
// NOTA: los procedimientos de este mdulo permiten "enganchar" cdigo de usuario
// a las respuestas y al bucle principal del juego.
// Los procedimientos de este mdulo son los nicos que deberan
// modificarse.
//
// v2.01 (03.04.2000)
//

// ********************************************************
// Los siguientes procedimientos (USR_...) son enganches desde el mdulo 'Librera'.
// Estos procedimientos se llaman cuando el jugador teclea alguna de las acciones
// asociadas y antes de que la librera los procese con lo que se puede
// colocar cdigo que responda a casos especiales.
//
// Algunos reciben parmetros que pueden usarse para determinar su comportamiento.
//
// En todos ellos se debe devolver un valor para indicar si se ha respondido
// o no a la accin.
// ********************************************************

// --------------------------------------------------------
// aqu podemos aadir informacin a la lnea de estado
// para ello slo tenemos que imprimirla con Print ya que
// al entrar a este procedimiento ya estar seleccionada
// la lnea de estado y el cursor posicionado justo detrs
// de la descripcin corta de la localidad
// si se quiere posicionar con exactitud el texto a imprimir
// se usar ScreenAt(pant_info,x,y) donde 'x' e 'y' marcan
// la posicin dentro de la lnea de estado
// --------------------------------------------------------
Sub USR_LineaEstado()

    ScreenAt(pant_info,500,0)
    Print("Turnos: " + turnos)

Return

// --------------------------------------------------------
// a este procedimiento se le llama antes de mover al jugador
// recibe:
//      'dir' verbo de movimiento que indica la direccin hacia
//            donde quiere moverse el jugador
// debe devolver TRUE si el jugador se mueve o FALSE si se queda donde est
// --------------------------------------------------------
Sub USR_MueveJugador(dir)
    Declare(ret)

    ret:=TRUE
    If (PSI[PSIJugador].Localidad="HABITACION") & (dir="SALIR") Then
        Epilogo3()
        ret:=FALSE
    EndIf

Return ret

// --------------------------------------------------------
// EXAMINAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Examinar()
    Declare(ret)

    ret:=FALSE

    If PSI[PSIJugador].Localidad="HABITACION" Then
        If ParsePreposicion="DEBAJO" Then
            Select ParseNombre1
                Case "CAMA"
                    If Not(jsj) Then
                        Print("Al mirar bajo la cama otros ojos te devuelven la mirada. Ves a un extrao individuo tendido en el suelo")
                        Print(" que sujeta unos papeles, y una extraa pluma de escribir metlica, con una incripcin minscula pero que puedes llegar a leer, a pesar de la poca luz: \"JSJ\"." + CR)
                        HablaPSI("Seguid, seguid con lo vuestro, por favor. Yo slo estaba tomando notas pero ya me iba.","dice el extrao individuo con una sonrisa de oreja a oreja.")
                        Print("Parpadeas y, como por arte de magia, el individuo de debajo de la cama ha desaparecido. Parece que tus sentidos te han jugado una mala pasada. O no?." + CR)
                        jsj:=TRUE
                    Else
                        Print("Est muy oscuro debajo de la cama pero no parece que haya nada de inters")
                        Print(" a excepcin de unas marcas grabadas en el suelo de madera que dicen algo como: \"JSJ EZTUBO AKIN\"" + CR)
                    EndIf
                    ret:=TRUE
            EndSelect
        Else
            Select ParseNombre1
                Case "PARED"
                    Print("Las paredes son de madera cubierta por un curioso barniz que desprende un tnue olor a rosas.")
                    Print(" Ya habas oido hablar a otros aventureros de este tipo de lujos, presentes en ciertos locales destinados al placer en todas sus formas." + CR)
                    ret:=TRUE
                Case "COLCHON"
                    Print("Es el colchn ms grande que has visto, diras que caben perfectamente tres o incluso cuatro personas sobre l." + CR)
                    ret:=TRUE            
                Case "COJINES"
                    Print("Son unos grandes cojines de piel suave, posiblemente de un extico animal que no eres capaz de distinguir." + CR)
                    ret:=TRUE
                Case "VENTANA"
                    Print("A travs de las vaporosa cortinas observas el ambiente nocturno de la ciudad.")
                    Print(" Varios borrachos y prostitutas pasean alegremente bajo la ventana." + CR)
                    ret:=TRUE
                Case *
                    If PSI["XZIRA"].Localidad=PSI[PSIJugador].Localidad Then
                        ret:=XZIRA_Examinar()
                    EndIf
            EndSelect
        EndIf
    EndIf
    
Return ret

// --------------------------------------------------------
// EXAMINAR DETALLES
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver el texto sobre los detalles adicionales del
// PSI o el objeto que se imprimirn al examinarlo
// --------------------------------------------------------
Sub USR_ExaminarDetalles(psi,nombre)
    Declare(txt)

    txt:=""
    If psi Then
        If nombre="XZIRA" Then
            If PSI[nombre].Vestido Then
                txt:="Lleva un minsculo vestido de cuero que deja al descubierto su torso y sus bronceadas piernas."
            Else
                txt:="Su cuerpo desnudo reluce contra la tnue luz de la luna que llega a entrar por la ventana."
                txt:=txt + " Un profundo valle de placer inicia su recorrido entre sus proporcionados senos para terminar surcando"
                txt:=txt + " las blancas llanuras de su vientre y desembocar en el vello pbico."
            EndIf
            If PSI[nombre].Tumbado Then
                txt:=txt + " Est tumbada sobre la cama."
            EndIf
        EndIf
    Else
        If nombre="VASO" Then
            If OBJ[nombre].Lleno<>"" Then
                txt:=" Est lleno de " + OBJ[nombre].Lleno + "."
            EndIf
        EndIf
    EndIf

    // aadimos un espacio adicional a los detalles
    If txt<>"" Then
        txt:=" " + txt
    EndIf

Return txt

// --------------------------------------------------------
// COGER
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Coger(psi,nombre)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// DEJAR
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Dejar(nombre)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// METER
// recibe:
//      'nombre' nombre del objeto al que nos referimos
//      'nombre_contenedor' nombre del objeto dnde queremos meterlo
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Meter(nombre,nombre_contenedor)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// SACAR
// recibe:
//      'nombre' nombre del objeto al que nos referimos
//      'nombre_contenedor' nombre del objeto dnde queremos meterlo
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Sacar(nombre,nombre_contenedor)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// ABRIR
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Abrir(nombre)
    Declare(ret)

    ret:=FALSE
    If (PSI[PSIJugador].Localidad="HABITACION") & (nombre="VENTANA") Then
        HablaPSI("Por favor, no abras la ventana. Hace fro fuera y adems... alguien podra molestarnos.","dice Xzira.")
        Print("Te lo piensas mejor y desistes de tu intento." + CR)
        ret:=TRUE
    EndIf

Return ret

// --------------------------------------------------------
// CERRAR
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Cerrar(nombre)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// PONER
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Poner(nombre)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// QUITAR
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Quitar(nombre)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// ENCENDER
// recibe:
//      'nombre' nombre del objeto/PSI sobre el que se acta
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Encender(nombre)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// APAGAR
// recibe:
//      'nombre' nombre del objeto/PSI sobre el que se acta
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Apagar(nombre)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// SABOREAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Saborear(psi,nombre)
    Declare(ret)

    ret:=FALSE

    If psi Then
        If nombre="XZIRA" Then
            If PSI[nombre].Localidad=PSI[PSIJugador].Localidad Then
                ret:=XZIRA_Saborear()
            EndIf
        EndIf
    EndIf


Return ret

// --------------------------------------------------------
// OLER
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Oler(psi,nombre)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// ESCUCHAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Escuchar(psi,nombre)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// TOCAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Tocar(psi,nombre)
    Declare(ret)

    ret:=FALSE

    If psi Then
        If nombre="XZIRA" Then
            If PSI[nombre].Localidad=PSI[PSIJugador].Localidad Then
                ret:=XZIRA_Tocar()
            EndIf
        EndIf
    Else
        If PSI[PSIJugador].Localidad="HABITACION" Then
            Select nombre
                Case "COLCHON"
                    Print("Est bastante mullido. Notas que est relleno de plumas de ave (bueno quiz no sean de ave pero que ms da)." + CR)
                    ret:=TRUE
                Case "PAREDES"
                    Print("Diras que son de madera de roble. Muy slidas y gruesas." + CR)
                    ret:=TRUE
                Case "CORTINA"
                    Print("El tejido es muy suave al tacto y tan vaporoso que se desliza fcilmente entre tus dedos." + CR)
                    ret:=TRUE
            EndSelect
        EndIf
    EndIf

Return ret

// --------------------------------------------------------
// LANZAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Lanzar()
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// GOLPEAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Golpear(psi,nombre)
    Declare(ret)

    ret:=FALSE

    If psi Then
        If nombre="XZIRA" Then
            Epilogo2()
        EndIf
    Else
        Select nombre
            Case "VASO"
                If EstaPresenteObj(nombre) Then
                    Print("Golpeas fuertemente el vaso y se hace aicos." + CR)
                    OBJ[nombre].Contenedor:=""
                    ret:=TRUE
                EndIf
            Case "BOTELLA"
                If EstaPresenteObj(nombre) Then
                    Print("La botella se rompe derramando su contenido sobre el suelo. Curiosamente el lquido se evapora a los pocos segundos." + CR)
                    OBJ[nombre].Contenedor:=""
                    ret:=TRUE
                EndIf
        EndSelect
    EndIf

Return ret

// --------------------------------------------------------
// CORTAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Cortar(psi,nombre)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// ATAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Atar(psi,nombre)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// DESATAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Desatar(psi,nombre)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// MOVER
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Mover(psi,nombre)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// MATAR
// recibe:
//      'nombre' nombre del PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Matar(nombre)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// BEBER
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Beber(nombre)
    Declare(ret)

    ret:=FALSE

    If nombre="VASO" Then
        If PSI[PSIJugador].Contiene(nombre) Then
            If OBJ[nombre].Lleno="" Then
                Print("Lstima que el vaso est vaco." + CR)
                ret:=TRUE
            Else
                Print("Te bebes todo el " + OBJ[nombre].Lleno + " del vaso de un solo trago." + CR)
                OBJ[nombre].Lleno:=""
                PSI[PSIJugador].Bebido:=PSI[PSIJugador].Bebido+1
                // si bebe mucho, el jugador terminar emborrachndose
                If PSI[PSIJugador].Bebido>2 Then
                    If PSI[PSIJugador].Bebido>5 Then
                        Epilogo4()
                    Else
                        Select PSI[PSIJugador].Bebido
                            Case 3
                                Print("Un reconfortante calor embriaga todo tu cuerpo." + CR)
                            Case 4
                                Print("Este licor te sabe mejor a cada trago, es realmente bueno. Quiz deberas beber un poco ms." + CR)
                            Case 5
                                Print("Despus de este ltimo trago los objetos de la habitacin parecen un poco ms borrosos. Quin habr puesto dos camas ah?" + CR)
                        EndSelect
                    EndIf
                Endif
                ret:=TRUE
            EndIf
        Else
            Print("No llevas el vaso." + CR)
            ret:=TRUE
        EndIf
    EndIf

Return ret

// --------------------------------------------------------
// COMER
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Comer(nombre)
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// SALTAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Saltar()
    Declare(ret)

    ret:=FALSE

    DisminuyeLibidoPSI("XZIRA",5)

Return ret

// --------------------------------------------------------
// GRITAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Gritar()
    Declare(ret)

    ret:=FALSE

    HablaPSI("Qu te pasa!, te duele algo?.","Xzira se muestra sorprendida por tu reaccin.")
    DisminuyeLibidoPSI("XZIRA",5)

Return ret

// --------------------------------------------------------
// CANTAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Cantar()
    Declare(ret)

    ret:=FALSE

    DisminuyeLibidoPSI("XZIRA",5)

Return ret

// --------------------------------------------------------
// BESAR
// recibe:
//      'psi' nombre del PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Besar(psi)
    Declare(ret)

    ret:=FALSE

    If psi="XZIRA" Then
        XZIRA_Besar()
        ret:=TRUE
    EndIf

Return ret

// --------------------------------------------------------
// DORMIR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Dormir()
    Declare(ret)

    ret:=FALSE

Return ret

// --------------------------------------------------------
// DECIR
// recibe:
//      'nombre' nombre del PSI al que nos referimos
//      'frase' frase que le decimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Decir(nombre,frase)
    Declare(ret)

    ret:=FALSE
    Select nombre
        Case "XZIRA"
            ret:=XZIRA_Hablar(frase)
    EndSelect

Return ret

// --------------------------------------------------------
// DAR
// recibe:
//      'objeto' nombre del objeto que queremos dar
//      'psi' nombre del PSI a quien le queremos dar el objeto
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Dar(objeto,psi)
    Declare(ret)

    ret:=FALSE
    If psi="XZIRA" Then
        If objeto="VASO" Then
            XZIRA_DarVaso()
            ret:=TRUE
        EndIf
    EndIf

Return ret

// --------------------------------------------------------
// acciones anteriores a que se procese el comando del jugador
// aqu se llega despus de analizar el comando pero antes
// de que se ejecute la accin asociada (si hubiese alguna)
// --------------------------------------------------------
Sub USR_Ant()

    // QUITAR ROPA A XZIRA
    // ---> DESNUDAR A XZIRA    
    If (ParseVerbo="QUITAR") & (ParseNombre1="ROPA") & (ParseNombre2="XZIRA") Then
        ParseVerbo:="DESNUDAR"
        ParseNombre1:=ParseNombre2
        ParseNombre2:=""
    EndIf

    // VERTER/VACIAR LICOR EN VASO
    // VERTER/VACIAR BOTELLA EN VASO
    // ---> LLENAR VASO
    If ((ParseVerbo="VERTER") | (ParseVerbo="VACIAR")) & ((ParseNombre1="LICOR") | (ParseNombre1="BOTELLA")) & (ParseNombre2="VASO") Then
        ParseVerbo:="LLENAR"
        ParseNombre1:="VASO"
        ParseNombre2:=""
    Endif

    // BEBER LIQUIDO
    // ---> BEBER VASO
    If (ParseVerbo="BEBER") & (ParseNombre1="LIQUIDO") Then
        ParseNombre1:="VASO"
    EndIf

    // HACER AMOR A XZIRA
    // ---> FOLLAR A XZIRA
    If (ParseVerbo="HACER") & (ParseNombre1="AMOR") & (ParseNombre2="XZIRA") Then
        ParseVerbo:="FOLLAR"
        ParseNombre1:="XZIRA"
        ParseNombre2:=""
    EndIf

    // METER PENE A XZIRA
    // ---> FOLLAR A XZIRA
    If (ParseVerbo="METER") & (ParseNombre1="PENE") & (ParseNombre2="XZIRA") Then
        ParseVerbo:="FOLLAR"
        ParseNombre1:="XZIRA"
        ParseNombre2:=""
    EndIf

    // PONER ROPA
    // ---> VESTIR
    If (ParseVerbo="PONER") & (ParseNombre1="ROPA") & (ParseNombre2="") Then
        ParseVerbo:="VESTIR"
        ParseNombre1:=""
    EndIf

    // QUITAR ROPA
    // ---> DESNUDAR
    If (ParseVerbo="QUITAR") & (ParseNombre1="ROPA") & (ParseNombre2="") Then
        ParseVerbo:="DESNUDAR"
        ParseNombre1:=""
    EndIf

    // TOCAR PENE
    // ---> MASTURBAR
    If (ParseVerbo="TOCAR") & (ParseNombre1="PENE") Then
        ParseVerbo:="MASTURBAR"
        ParseNombre1:=""
        ParseNombre2:=""
    EndIf

    // TOCAR xxx XZIRA
    // ---> TOCAR XZIRA xxx
    If (ParseVerbo="TOCAR") & (ParseNombre2="XZIRA") Then
        ParseNombre2:=ParseNombre1
        ParseNombre1:="XZIRA"
    EndIf

    // BESAR xxx XZIRA
    // ---> SABOREAR/CHUPAR XZIRA xxx
    If (ParseVerbo="BESAR") & (ParseNombre2="XZIRA") Then
        ParseVerbo:="SABOREAR"
        ParseNombre2:=ParseNombre1
        ParseNombre1:="XZIRA"
    EndIf

    // BESAR XZIRA xxx
    // ---> SABOREAR/CHUPAR XZIRA xxx
    If (ParseVerbo="BESAR") & (ParseNombre1="XZIRA") & (ParseNombre2<>"") Then
        ParseVerbo:="SABOREAR"
    EndIf

    // SABOREAR/CHUPAR xxx XZIRA
    // ---> SABOREAR/CHUPAR XZIRA xxx
    If (ParseVerbo="SABOREAR") & (ParseNombre2="XZIRA") Then
        ParseNombre2:=ParseNombre1
        ParseNombre1:="XZIRA"
    EndIf
    
    // TOCAR xxx (xxx=parte cuerpo de Xzira)
    // ---> TOCAR XZIRA xxx
    If (ParseVerbo="TOCAR") & XZIRA_ParteCuerpo(ParseNombre1) Then
        ParseNombre2:=ParseNombre1
        ParseNombre1:="XZIRA"
    EndIf

    // SABOREAR/CHUPAR xxx (xxx=parte cuerpo de Xzira)
    // ---> SABOREAR/CHUPAR XZIRA xxx
    If (ParseVerbo="SABOREAR") & XZIRA_ParteCuerpo(ParseNombre1) Then
        ParseNombre2:=ParseNombre1
        ParseNombre1:="XZIRA"
    EndIf

Return

// --------------------------------------------------------
// acciones posteriores a que se procese el comando del jugador
// --------------------------------------------------------
Sub USR_Post()

    // comprobamos si el jugador est vestido
    If PSI[PSIJugador].Contiene("TAPARRABOS") & OBJ["TAPARRABOS"].Puesto Then
        PSI[PSIJugador].Vestido:=TRUE
    Else    
        PSI[PSIJugador].Vestido:=FALSE
    EndIf

    XZIRA_Mueve()

Return

// --------------------------------------------------------
// respuestas a otras acciones no contempladas en la librera estndar
// debe devolver TRUE si se di una respuesta a al accin o FALSE si no
// --------------------------------------------------------
Sub USR_Respuesta()
    Declare(ret)
    Declare(obj)

    ret:=FALSE

    Select ParseVerbo
        Case "XYZZY"
            If (OBJ["BOTELLA"].Contenedor="") | (OBJ["VASO"].Contenedor="") Then
                Print("Un sonido cmo de campanillas inunda la habitacin y entre una nube de humo aparece algo en el suelo." + CR)
                OBJ["BOTELLA"].TipoContenedor:=0
                OBJ["BOTELLA"].Contenedor:="HABITACION"
                OBJ["VASO"].TipoContenedor:=0
                OBJ["VASO"].Contenedor:="HABITACION"
            EndIf
            Print("Una voz susurra dentro de tu cabeza... \[C]mira debajo de la cama\[C]." + CR)
            ret:=TRUE
        Case "LIBIDO"
            Print("Lbido de jugador: " + PSI[PSIJugador].Libido + CR)
            Print("Lbido de Xzira: " + PSI["XZIRA"].Libido + CR)
            turnos:=turnos-1
            ret:=TRUE
        Case "DESNUDAR"
            If ParseNombre1="XZIRA" Then
                XZIRA_Desnudar(1)
            Else
                If ParseNombre1="" Then
                    If PSI[PSIJugador].Vestido Then
                        Print("Te quitas el taparrabos y lo arrojas al suelo." + CR)
                        If (PSI["XZIRA"].Libido>=30) & PSI["XZIRA"].Vestido Then
                            XZIRA_Desnudar(0)
                        Else
                            HablaPSI("Vaya, ests muy juguetn...","")
                            AumentaLibidoPSI("XZIRA",0,50,10)
                            Print("Xzira acaricia tu pecho y desliza su mano hacia abajo, muy lentamente..." + CR)
                        EndIf
                        OBJ["TAPARRABOS"].Puesto:=FALSE
                        OBJ["TAPARRABOS"].Dejar("HABITACION")
                        AumentaLibidoPSI(PSIJugador,0,50,20)
                    Else
                        Print("Ests desnudo ya." + CR)
                    EndIf
                Else
                    Print("A quin?" + CR)
                EndIf
            EndIf
            ret:=TRUE
        Case "VESTIR"
            If ParseNombre1="XZIRA" Then
                If PSI["XZIRA"].Vestido Then
                    Print("Acaso no est ya vestida?" + CR)
                Else
                    Print("No logras ver la ropa de Xzira por ningn lado. Seguramente est tirada en un oscuro rincn de la habitacin.")
                    Print(" De todas formas, no parece que la semielfa se sienta incmoda desnuda." + CR)
                EndIf
            Else
                If PSI[PSIJugador].Vestido Then
                    Print("Ya ests vestido." + CR)
                Else
                    PSI[PSIJugador].Coger("TAPARRABOS")
                    OBJ["TAPARRABOS"].Puesto:=TRUE
                    Print("Te pones el taparrabos." + CR)
                Endif
            EndIf
            ret:=TRUE
        Case "FOLLAR"
            If ParseNombre1="" Then
                Print("A quin?" + CR)
            Else
                If ParseNombre1="XZIRA" Then
                    XZIRA_Follar()
                EndIf
            EndIf
            ret:=TRUE
        Case "LLENAR"
            obj:=NombreCompleto(ParseNombre1,ParseAdjetivo1)
            If obj="VASO" Then
                If OBJ[obj].Lleno="" Then
                    If PSI[PSIJugador].Contiene("BOTELLA") Then
                        If OBJ["BOTELLA"].Abierto Then
                            Print("Llenas el vaso con una cantidad generosa de licor de la botella." + CR)
                            OBJ[obj].Lleno:="licor"
                        Else
                            Print("La botella est cerrada." + CR)
                        EndIf
                    Else
                        Print("No tienes nada conque llenar el vaso." + CR)
                    EndIf
                Else
                    Print("El vaso ya est lleno de " + OBJ["VASO"].Lleno + "." + CR)
                EndIf
            Else
                If obj="" Then
                    Print("Qu quieres llenar?" + CR)
                Else
                    Print("No puedes llenar eso." + CR)
                EndIf
            EndIf
            ret:=TRUE
        Case "MASTURBAR"
            If ParseNombre1="" Then
                If PSI[PSIJugador].Vestido Then
                    Print("Aproximas tu mano a la entrepierna y la introduces entre el taparrabos. Imprimes a tu")
                    Print(" miembro un ligero vaivn que aumentas de ritmo progresivamente. Tu mano sujeta ahora")
                    Print(" una verga endurecida." + CR)
                    HablaPSI("Eh!... tranquilo... deja algo para m.","Xzira te observa divertida")
                    AumentaLibidoPSI(PSIJugador,0,100,5)
                Else
                    Print("Sin ningn pudor coges tu miembro viril con una de tus fuertes manos y comienzas")
                    Print(" a frotrtelo con un movimiento de vaivn muy lento primero y ms rpido despus.")
                    Print(" Xzira te observa divertida mientras tu verga comienza a endurecerse." + CR)
                    HablaPSI("Deja un poco para m hombretn","la semielfa pronuncia la frase entre susurros")
                    AumentaLibidoPSI(PSIJugador,0,100,5)
                EndIf
                If PSI[PSIJugador].Libido>90 Then
                    Print("Tu verga estalla en una cascada de semen que se esparce por el suelo. Sigues sujetndote el miembro")
                    Print(" hasta que deja de gotear." + CR)
                    Epilogo5()
                Else
                    If PSI[PSIJugador].Libido>80 Then
                        Print("Una oleada de calor sacude tus testculos y se desliza hacia la punta de tu endurecido miembro." + CR)
                    EndIf
                EndIf
            Else
                If ParseNombre1="XZIRA" Then
                    XZIRA_Masturbar()
                Else
                    Print("A quin?" + CR)
                EndIf
            EndIf
            ret:=TRUE
        Case "TUMBAR"
            If ParseNombre1="CAMA" Then
                If PSI[PSIJugador].Tumbado Then
                    Print("Ya ests tumbado en la cama." + CR)
                Else
                    Print("Te tumbas en la cama." + CR)
                    PSI[PSIJugador].Tumbado:=TRUE
                    XZIRA_Tumbar()
                EndIf
            Else
                If ParseNombre1="" Then
                    If PSI[PSIJugador].Tumbado Then
                        Print("Ya ests tumbado en la cama." + CR)
                    Else
                        Print("Dnde quieres tumbarte?." + CR)
                    EndIf
                Else
                    Print("No puedes tumbarte ah." + CR)
                EndIf
            EndIf
            ret:=TRUE
        Case "LEVANTAR"
            If PSI[PSIJugador].Tumbado Then
                Print("Te levantas." + CR)
                PSI[PSIJugador].Tumbado:=FALSE
                If PSI["XZIRA"].Tumbado Then
                    HablaPSI("Uhmmm... no te vayas... ven conmigo...","Xzira se estira y contonea sobre la cama.")
                EndIf
            Else
                Print("Ya ests de pie." + CR)
            EndIf
            ret:=TRUE
    EndSelect

Return ret

// --------------------------------------------------------
// mensajes de copyright
// --------------------------------------------------------
Sub USR_Copyright()
    Declare(spc)
    Declare(copyright)
    Declare(email)
    Declare(web)
    Declare(descripcion)

    // personalizamos distribucin de pantalla
    ScreenPos(pant_grf,0,tamy_info)
    ScreenSize(pant_grf,320,tamy-tamy_info-ajustey)
    ScreenPos(0,320,tamy_info)
    ScreenSize(0,tamx-ajustex-320,tamy-tamy_info-ajustey)

    // dibujo de presentacin
    ScreenImg(pant_grf,"#1")

    spc:="        "
    copyright:="(c)2000 Login:"
    email:="jsj666@hotmail.com"
    web:="http://pagina.de/jsj"
    descripcion:="Una 'mini-aventura' de temtica fantstico-ertica."

    Print(CR + "    \[Times New Roman]\[12]\[RGB(FFFFCC)]\[N]" + titulo + "\[N]" + CR)
    Print("\[10]\[C]" + spc + copyright + "\[C]" + CR)
    Print(spc + "\[RGB(8080FF)]\[S]" + web + "\[S]    " + email)
    Print(CR + spc + "\[RGB(FFCCCC)]" + descripcion)
    Print(CR + spc + "Versin " + version + " / intrprete " + VerVS)
    // inicializamos el tipo de letra y color del texto
    Print(tipo_letra + color_letra + CR + CR)

Return

// --------------------------------------------------------
// introduccin
// --------------------------------------------------------
Sub USR_Inicio()
    Declare(opc)

    opc:=Input("Quieres leer la nota del autor? ")
    If UCase(Left(opc,1))="S" Then
        Print(CR + "\[12]\[N]NOTA DEL AUTOR:\[N]" + tipo_letra + CR + CR)
        Print("\[C]")
        Print("A continuacin vas a experimentar una aventura atpica. No se trata de resolver")
        Print(" complejos puzzles ni de recorrer complicados laberintos. Ms bien se trata de")
        Print(" algo diferente, de un juego, el juego del amor. No el amor platnico, ni el amor")
        Print(" puro de los eternos enamorados. Se trata del amor pasional. De la pasin desatada.")
        Print(" Del deseo. El escenario no puede ser ms bsico. Hombre y mujer unidos por un ardiente")
        Print(" deseo que les consume. Debers participar en este juego como mejor te parezca.")
        Print(" Tu pareja colaborar en todo lo posible." + CR + CR)
        Print("Por supuesto el objetivo de este peculiar juego de pasin es llegar al xtasis total, creo que")
        Print(" no es necesario explicar ms. Realmente no es necesario que t llegues al xtasis, (aunque si")
        Print(" esta aventura consigue provocar tal reaccin me dar por ms que satisfecho) pero s tu pareja." + CR + CR)
        Print("\[N]Ahora viene el aviso necesario\[N]: esta aventura contiene textos y descripciones para adultos.")
        Print(" En todo momento he intentado mantener un tono que no llegue a la obscenidad pero quiz")
        Print(" s que la roce en ciertos pasajes. Bueno, no voy a decir que esta aventura es para mayores")
        Print(" de edad pero s recomendara jugarla con una mentalidad abierta y desinhibida." + CR + CR)
        Print("Esta aventura adems est orientada a un pblico claramente masculino. Me consta que el nmero")
        Print(" de jugadoras es lo suficientemente excaso (inexistente?) como para no haber realizado la versin")
        Print(" femenina de la historia (aunque ganas no me han faltado)." + CR + CR)
        Print(CR + CR + "                    JSJ." + CR + CR)
        Print("\[C]")
    
        PulsaTecla()
        ScreenCls(0)
    EndIf

    Print(CR + "\[12]\[N]PROLOGO:\[N]" + tipo_letra + CR + CR)
    Print("Tus correras por las tierras del sur te haban llevado a aquella ciudad. No era")
    Print(" la ms grande urbe de la zona pero al menos dispona de las comodidades y")
    Print(" placeres que las pequeas aldeas no podan darte." + CR + CR)

    Print("Como todos los hombres del norte atraas las miradas tanto de hombres, celosos y")
    Print(" temerosos de tu magnfica complexin y de tu impresionante estatura, como de")
    Print(" mujeres en cuyos ojos adivinabas oscuros deseos." + CR + CR)

    Print("Llevabas una vida de riesgos y aventuras. T, un guerrero desde que viste la luz")
    Print(" en este hostil mundo de peligros. Ya habas frecuentado varios grupos de")
    Print(" aventureros en las ms osadas expediciones en bsqueda de riquezas. Tu espada")
    Print(" siempre haba sido una valiosa aliada que te haba sacado de ms de un apuro." + CR + CR)

    Print("El grupo de aventureros que esa noche pernoctaba en la taberna \[N]\"Fuego de")
    Print(" Dragn\"\[N] pareca muy preocupado. Apenas hablaban entre ellos y menos con los")
    Print(" parroquianos. Haba un clrigo, claramente reconocible por sus smbolos")
    Print(" religiosos, un par de guerreros que beban sin parar, jarra tras jarra de un")
    Print(" espumoso lquido, y tres magos. Dios!, sabras distinguir un mago a kilmetros")
    Print(" de distancia. Todos llevaban mutitud de anillos, medallones, y solan cargar con")
    Print(" sus preciados libros. Y eso era slo parte de lo que llevaban a la vista." + CR + CR)

    Print("El grupo de magos estaba separado del resto, en un rincn, claramente")
    Print(" concentrados sobre una pila de libros y pergaminos abiertos. No hablaban pero")
    Print(" una lenta y meldica letana proceda de sus bocas entrecerradas. Mientras les")
    Print(" contemplabas ella te mir. Era una semielfa. Al menos eso pareca ya que sus")
    Print(" orejas puntiagudas asomaban entre su largo y sedoso pelo castao. Cuando se")
    Print(" levant, dejando a sus compaeros magos ensimismados sobre sus libros, y pas a")
    Print(" tu lado oliste un suave perfume que pareca envolverla como una nube invisible.")
    Print(" Apenas iba vestida. Tu mirada no poda apartarse de la tersa piel de su torso,")
    Print(" de las proporcionadas curvas de sus caderas, de sus voluptuosos pechos apenas")
    Print(" contenidos por una prenda de cuero." + CR + CR)

    Print("Ella tambin se fij en t. Qu mujer no se fijara en un brbaro medio desnudo")
    Print(" cuyo cuerpo cubierto de proporcionados msculos prometa las ms calurosas y")
    Print(" hmedas pasiones?." + CR)

    HablaPSI("Sgueme.","")
    Print("Una voz meldica, suave, dulce acarici durante unos segundos tus")
    Print(" oidos. Creste que fue tu imaginacin que te jugaba una mala pasada pero al")
    Print(" volver la vista ah estaba la semielfa, sus carnosos labios junto a tu oreja." + CR)
    HablaPSI("Ven, creo que tengo algo que deseas.","")
    Print("Volvi a repetir. Cada palabra te lacer en lo ms profundo como ningn arma")
    Print(" haba hecho hasta ahora. Te limitaste a sonreir y a seguir a la mujer")
    Print(" a travs de la taberna, repleta de sudorosos cuerpos, hacia el piso superior." + CR + CR)

    Print("Antes de que se cerrase la puerta de la habitacin diste un ltimo vistazo a")
    Print(" la chimenea que arda en el piso de abajo. Ahora empezabas a comprender el")
    Print(" porqu del nombre de la taberna, \[N]\"Fuego de Dragn\"\[N], era muy apropiado y no")
    Print(" slo por el fuego que calentaba el local sino por el fuego que arda ahora en tu")
    Print(" interior." + CR + CR)
    
    PulsaTecla()

    // restauramos configuracin de pantalla
    DestroyScreen(pant_grf)
    hay_graficos:=FALSE
    ScreenPos(0,0,tamy_info)
    ScreenSize(0,tamx-ajustex,tamy-tamy_info-ajustey)
    ScreenCls(0)

    Print("\[RGB(E0E000)]\[Times New Roman]\[C](Teclea \[N]AYUDA\[N] para obtener informacin adicional)\[C]" + tipo_letra + color_letra + CR + CR)

Return

// --------------------------------------------------------
// msica de fondo
// --------------------------------------------------------
Sub USR_MusicaFondo()

    If hay_sonido Then
        musica_fondo:=LoadSong("#9999")
        PlaySong(musica_fondo)
    EndIf

Return

// --------------------------------------------------------
// pantalla de ayuda
// --------------------------------------------------------
Sub USR_Ayuda()

    Print(CR + "\[RGB(E0E000)]\[Times New Roman]En esta aventura tienes disponibles los verbos de accin comunes a casi todas")
    Print(" las aventuras (entre parntesis se indica la forma abreviada):" + CR + CR)
    Print("\[N]COGER, DEJAR, MIRAR (M), EXAMINAR (EX), INVENTARIO (I), METER, SACAR, ABRIR, CERRAR, PONER, QUITAR, ENCENDER, APAGAR, ")
    Print("GOLPEAR, MATAR, ATAR, DESATAR, CORTAR, MOVER, OLER, SABOREAR, TOCAR, ESCUCHAR, LANZAR, BEBER, COMER, ")
    Print("SALTAR, GRITAR, CANTAR, BESAR, DORMIR, DAR")
    Print(CR + CR + "\[N]")
    Print("Se pueden teclear acciones mltiples en una sola lnea sin ms que encadenarlas con comas (,) o con \[N]Y\[N].")
    Print(" Adems se pueden usar pronombres para referirse al ltimo objeto referenciado dentro de una accin, por ejemplo:" + CR + CR)
    Print("\[N]COGER EL LIBRO, LEERLO Y DEJARLO\[N]" + CR + CR)
    Print("Adems puedes hablar con los personajes usando la forma:" + CR + CR)
    Print("\[N]DECIR A PERSONAJE \"FRASE\"\[N]" + CR + CR)
    Print("se puede usar la forma abreviada si hay un slo personaje en la localidad:" + CR + CR)
    Print("\[N]DECIR \"FRASE\"\[N]" + CR + CR)
    Print("En cualquier momento puedes hacer que la accin transcurra sin que t hagas nada usando el verbo \[N]ESPERAR (Z)\[N]" + CR + CR)
    Print("Adems puedes guardar y recuperar el estado del juego con los comandos \[N]GUARDAR\[N] y \[N]CARGAR\[N]" + CR + CR)
    Print("Para salir del juego debes teclear \[N]FIN\[N] o \[N]ABANDONAR\[N], pero acurdate de guardar la partida si quieres continuarla ms adelante" + CR + CR)
    Print("\[N]TURNOS\[N] te mostrar cuantos turnos llevas jugados." + CR + CR)
    Print("\[N]LIBIDO\[N] muestra cmo va progresando el 'juego' ;-)." + CR + CR)
    Print(tipo_letra + color_letra)
    PulsaTecla()

Return

// --------------------------------------------------------
// ESPERAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Esperar()
    Declare(ret)

    ret:=FALSE

    //DisminuyeLibidoPSI("XZIRA",5)

Return ret
